/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.generator;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import org.betterx.bclib.api.v2.generator.BCLBiomeSource;
import org.betterx.bclib.api.v2.generator.BiomePicker;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.interfaces.BiomeMap;

public abstract class BiomeDecider {
    protected BiomePicker picker;
    protected BiomeMap map;
    private final BiomePredicate predicate;
    static List<BiomeDecider> DECIDERS = new LinkedList<BiomeDecider>();

    public static void registerHighPriorityDecider(class_2960 location, BiomeDecider decider) {
        if (DECIDERS.size() == 0) {
            DECIDERS.add(decider);
        } else {
            DECIDERS.add(0, decider);
        }
    }

    public static void registerDecider(class_2960 location, BiomeDecider decider) {
        DECIDERS.add(decider);
    }

    protected BiomeDecider(BiomePredicate predicate) {
        this(null, predicate);
    }

    protected BiomeDecider(class_2378<class_1959> biomeRegistry, BiomePredicate predicate) {
        this.predicate = predicate;
        this.map = null;
        this.picker = biomeRegistry == null ? null : new BiomePicker(biomeRegistry);
    }

    public abstract boolean canProvideFor(class_1966 var1);

    public abstract BiomeDecider createInstance(BCLBiomeSource var1);

    public void createMap(BiomeMapBuilderFunction mapBuilder) {
        this.map = mapBuilder.create(this.picker, -1);
    }

    public void clearMapCache() {
        this.map.clearCache();
    }

    public boolean addToPicker(BCLBiome biome) {
        if (this.predicate.test(biome)) {
            this.picker.addBiome(biome);
            return true;
        }
        return false;
    }

    public void rebuild() {
        this.picker.rebuild();
    }

    public BiomeAPI.BiomeType suggestType(BiomeAPI.BiomeType originalType, BiomeAPI.BiomeType suggestedType, int maxHeight, int blockX, int blockY, int blockZ, int quarterX, int quarterY, int quarterZ) {
        return this.suggestType(originalType, suggestedType, 0.0, maxHeight, blockX, blockY, blockZ, quarterX, quarterY, quarterZ);
    }

    public abstract BiomeAPI.BiomeType suggestType(BiomeAPI.BiomeType var1, BiomeAPI.BiomeType var2, double var3, int var5, int var6, int var7, int var8, int var9, int var10, int var11);

    public abstract boolean canProvideBiome(BiomeAPI.BiomeType var1);

    public BiomePicker.ActualBiome provideBiome(BiomeAPI.BiomeType suggestedType, int posX, int posY, int posZ) {
        return this.map.getBiome(posX, posY, posZ);
    }

    @FunctionalInterface
    public static interface BiomePredicate {
        public boolean test(BCLBiome var1);
    }

    @FunctionalInterface
    public static interface BiomeMapBuilderFunction {
        public BiomeMap create(BiomePicker var1, int var2);
    }
}

